/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;

public class ShortType
implements ExtendedType<Short> {
    protected boolean widenShorts;

    public ShortType(boolean widenShorts) {
        this.widenShorts = widenShorts;
    }

    @Override
    public String getClassName() {
        return Short.class.getName();
    }

    @Override
    public Short materializeObject(ResultSet rs, int index, int type) throws Exception {
        short s = rs.getShort(index);
        return rs.wasNull() ? null : Short.valueOf(s);
    }

    @Override
    public Short materializeObject(CallableStatement st, int index, int type) throws Exception {
        short s = st.getShort(index);
        return st.wasNull() ? null : Short.valueOf(s);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Short value, int pos, int type, int precision) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else if (this.widenShorts) {
            statement.setInt(pos, value.intValue());
        } else {
            statement.setShort(pos, value);
        }
    }

    @Override
    public String toString(Short value) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }
}

