/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.DBWizardAction;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.dialog.db.DbActionOptionsDialog;
import org.apache.cayenne.modeler.pref.DataMapDefaults;

public class GetDbConnectionAction
extends DBWizardAction<DbActionOptionsDialog> {
    public static final String DIALOG_TITLE = "Configure Connection to Database";
    private static final String ACTION_NAME = "Configure Connection";
    private static final String ICON_NAME = "icon-dbi-config.png";

    public GetDbConnectionAction(Application application) {
        super(ACTION_NAME, application);
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    protected DbActionOptionsDialog createDialog(Collection<String> catalogs, Collection<String> schemas, String currentCatalog, String currentSchema, int command) {
        return null;
    }

    @Override
    public void performAction(ActionEvent e) {
        DataSourceWizard connectWizard = this.dataSourceWizardDialog(DIALOG_TITLE);
        if (connectWizard == null) {
            return;
        }
        DataMapDefaults dataMapDefaults = this.getProjectController().getDataMapPreferences(this.getProjectController().getCurrentDataMap());
        if (connectWizard.getConnectionInfo().getDbAdapter() != null) {
            dataMapDefaults.getCurrentPreference().put("dbAdapter", connectWizard.getConnectionInfo().getDbAdapter());
        } else {
            dataMapDefaults.getCurrentPreference().remove("dbAdapter");
        }
        dataMapDefaults.getCurrentPreference().put("url", connectWizard.getConnectionInfo().getUrl());
        dataMapDefaults.getCurrentPreference().put("userName", connectWizard.getConnectionInfo().getUserName());
        dataMapDefaults.getCurrentPreference().put("password", connectWizard.getConnectionInfo().getPassword());
        dataMapDefaults.getCurrentPreference().put("jdbcDriver", connectWizard.getConnectionInfo().getJdbcDriver());
    }
}

