/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.XMPPBridgeProvider;

public class XMPPModule
implements Module {
    public static final String XMPP_BRIDGE_PROPERTIES_MAP = "cayenne.server.xmpp_bridge";

    public static void contributeHost(Binder binder, String host) {
        XMPPModule.contributeProperties(binder).put("cayenne.XMPPBridge.xmppHost", (Object)host);
    }

    public static void contributePort(Binder binder, int port) {
        XMPPModule.contributeProperties(binder).put("cayenne.XMPPBridge.xmppPort", (Object)Integer.toString(port));
    }

    public static void contributeLogin(Binder binder, String login, String password) {
        XMPPModule.contributeProperties(binder).put("cayenne.XMPPBridge.xmppLogin", (Object)login);
        XMPPModule.contributeProperties(binder).put("cayenne.XMPPBridge.xmppPassword", (Object)password);
    }

    public static void contributeChatService(Binder binder, String chatService) {
        XMPPModule.contributeProperties(binder).put("cayenne.XMPPBridge.xmppChatService", (Object)chatService);
    }

    public static void contributeSecureConnection(Binder binder, boolean secure) {
        XMPPModule.contributeProperties(binder).put("cayenne.XMPPBridge.xmppSecure", (Object)Boolean.toString(secure));
    }

    private static MapBuilder<String> contributeProperties(Binder binder) {
        return binder.bindMap(String.class, XMPP_BRIDGE_PROPERTIES_MAP);
    }

    public void configure(Binder binder) {
        XMPPModule.contributeChatService(binder, "conference");
        binder.bind(EventBridge.class).toProvider(XMPPBridgeProvider.class).withoutScope();
    }
}

