/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.util;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexCursorUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private IndexCursorUtils() {
    }

    public static Throwable close(IIndexCursor cursor, Throwable root) {
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (Throwable th) {
                try {
                    LOGGER.log(Level.WARN, "Failure closing a cursor", th);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                root = ExceptionUtils.suppress((Throwable)root, (Throwable)th);
            }
        }
        return root;
    }

    public static void open(List<IIndexAccessor> accessors, IIndexCursor[] cursors, ISearchPredicate pred) throws HyracksDataException {
        int opened = 0;
        try {
            for (int i = 0; i < cursors.length; ++i) {
                if (accessors.get(i) != null) {
                    accessors.get(i).search(cursors[i], pred);
                }
                ++opened;
            }
        }
        catch (Throwable th) {
            for (int j = 0; j < opened; ++j) {
                IndexCursorUtils.close(cursors[j], th);
            }
            throw HyracksDataException.create((Throwable)th);
        }
    }

    public static void open(IIndexAccessor[] accessors, IIndexCursor[] cursors, ISearchPredicate pred) throws HyracksDataException {
        int opened = 0;
        try {
            for (int i = 0; i < accessors.length; ++i) {
                if (accessors[i] != null) {
                    accessors[i].search(cursors[i], pred);
                }
                ++opened;
            }
        }
        catch (Throwable th) {
            for (int j = 0; j < opened; ++j) {
                IndexCursorUtils.close(cursors[j], th);
            }
            throw HyracksDataException.create((Throwable)th);
        }
    }

    public static Throwable close(IIndexCursor[] cursors, Throwable th) {
        for (int j = 0; j < cursors.length; ++j) {
            th = IndexCursorUtils.close(cursors[j], th);
        }
        return th;
    }
}

