/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Md5Utils;

@SdkInternalApi
public class AddContentMd5HeaderInterceptor
implements ExecutionInterceptor {
    private static final ExecutionAttribute<String> CONTENT_MD5_ATTRIBUTE = new ExecutionAttribute("contentMd5");
    private static final List<Class> BLACKLIST_METHODS = Arrays.asList(PutObjectRequest.class, UploadPartRequest.class);

    public Optional<RequestBody> modifyHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        if (!BLACKLIST_METHODS.contains(context.request().getClass()) && context.requestBody().isPresent() && !context.httpRequest().firstMatchingHeader("Content-MD5").isPresent()) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IoUtils.copy((InputStream)((RequestBody)context.requestBody().get()).contentStreamProvider().newStream(), (OutputStream)baos);
                executionAttributes.putAttribute(CONTENT_MD5_ATTRIBUTE, (Object)Md5Utils.md5AsBase64((byte[])baos.toByteArray()));
                return context.requestBody();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return context.requestBody();
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        String contentMd5 = (String)executionAttributes.getAttribute(CONTENT_MD5_ATTRIBUTE);
        if (contentMd5 != null) {
            return (SdkHttpRequest)((SdkHttpRequest.Builder)context.httpRequest().toBuilder()).putHeader("Content-MD5", contentMd5).build();
        }
        return context.httpRequest();
    }
}

